<?php
    include "includes/header.php";
    include "alert/alert.php";
	include "includes/function.php";
	$img_path = 'images';
    if (!is_dir($img_path)) {
        mkdir($img_path, 0755, true);
    }
    
    
    $countStr='';
    $no_data_status=false;
    $count=$monthCount=0;

    for ($mon=1; $mon<=12; $mon++) {

        if(isset($_GET['filterByYear'])){
    $year=$_GET['filterByYear'];

  }
  else{
    $year=date('Y');
  }

  $month = date('M', mktime(0,0,0,$mon, 1, $year));

  $sql_user="SELECT `user_id` FROM tbl_users WHERE `registered_on` <> 0 AND DATE_FORMAT(FROM_UNIXTIME(`registered_on`), '%c') = '$mon' AND DATE_FORMAT(FROM_UNIXTIME(`registered_on`), '%Y') = '$year' AND role = 'User'";

        $count=mysqli_num_rows(mysqli_query($mysqli, $sql_user));

        $countStr.="['".$month."', ".$count."], ";

        if($count!=0){
          $monthCount++;
        }

    }

    if($monthCount!=0){
      $no_data_status=false;
    }
    else{
      $no_data_status=true;
    }

    $countStr=rtrim($countStr, ", ");
    
    function get_total_news_count()
    {

      global $mysqli;
      $qry_counts = "SELECT COUNT(*) as num FROM tbl_news WHERE news_status NOT IN (2,3)";
      $total_count = mysqli_fetch_array(mysqli_query($mysqli, $qry_counts));
      $total_count = $total_count['num'];
      return $total_count;
    }
?>
		
		 <div class="main-content">
        <section class="section">
          <div class="section-body">
              <?php if(isset($_SESSION['msg'])){?> 
                 <div class="alert alert-primary alert-dismissible" role="alert"> <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">×</span></button>
                  <?php echo $alert_msg[$_SESSION['msg']] ; ?></a> </div>
                <?php unset($_SESSION['msg']);}?> 
            <div class="row">
                
                
              <div class="col-12 col-md-6 col-lg-4">
                <div class="card card-primary">
                     <div class="card-header">
                    <h4>Category</h4>
                    <div class="card-header-action">
                        <a href="add-category?add=yes" class="btn btn-primary">
                         Add New
                      </a>
                      <a href="manage-category" class="btn btn-primary">
                        View All
                      </a>
                    </div>
                  </div>
              <div class="card-statistic-4">
                  <div class="align-items-center justify-content-between">
                    <div class="row ">
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                        <div class="card-content">
                          <h2 class="mb-3  text-warning font-50"><?=thousandsNumberFormat(counting("tbl_category", "id"))?></h2>
                        </div>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                        <span class="fa-stack fa-3x fa-lg fa-pull-right ">
                            <i class="fa fa-circle fa-stack-2x"></i>
                             <i class="fa fa-sitemap fa-stack-1x fa-inverse"></i>
                        </span>
                      </div>
                    </div>
                  </div>
                </div>
                </div>
                </div>
                
                <div class="col-12 col-md-6 col-lg-4">
                <div class="card card-primary">
                     <div class="card-header">
                    <h4>News</h4>
                    <div class="card-header-action">
                        <a href="add-news?add=yes" class="btn btn-primary">
                         Add New
                      </a>
                      <a href="manage-news" class="btn btn-primary">
                        View All
                      </a>
                    </div>
                  </div>
              <div class="card-statistic-4">
                  <div class="align-items-center justify-content-between">
                    <div class="row ">
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                        <div class="card-content">
                          <h2 class="mb-3  text-warning font-50"><?=thousandsNumberFormat(get_total_news_count())?></h2>
                        </div>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                          <span class="fa-stack fa-3x fa-lg fa-pull-right ">
                            <i class="fa fa-circle fa-stack-2x"></i>
                             <i class="fa fa-newspaper fa-stack-1x fa-inverse"></i>
                        </span>
                      </div>
                    </div>
                  </div>
                </div>
                </div>
                </div>
                
                <div class="col-12 col-md-6 col-lg-4">
                <div class="card card-primary">
                     <div class="card-header">
                    <h4>News Approval</h4>
                    <div class="card-header-action">
                      <a href="news-approval" class="btn btn-primary">
                        View All
                      </a>
                    </div>
                  </div>
              <div class="card-statistic-4">
                  <div class="align-items-center justify-content-between">
                    <div class="row ">
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                        <div class="card-content">
                          <h2 class="mb-3  text-warning font-50"><?=thousandsNumberFormat(countingNewsApproval("tbl_news", "id"))?></h2>
                        </div>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                          <span class="fa-stack fa-3x fa-lg fa-pull-right ">
                            <i class="fa fa-circle fa-stack-2x"></i>
                             <i class="fa fa-newspaper fa-stack-1x fa-inverse"></i>
                        </span>
                      </div>
                    </div>
                  </div>
                </div>
                </div>
                </div>
                
                <div class="col-12 col-md-6 col-lg-4">
                <div class="card card-primary">
                     <div class="card-header">
                    <h4>Videos</h4>
                    <div class="card-header-action">
                        <a href="add-video?add=yes" class="btn btn-primary">
                         Add New
                      </a>
                      <a href="manage-videos" class="btn btn-primary">
                        View All
                      </a>
                    </div>
                  </div>
              <div class="card-statistic-4">
                  <div class="align-items-center justify-content-between">
                    <div class="row ">
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                        <div class="card-content">
                          <h2 class="mb-3  text-warning font-50"><?=thousandsNumberFormat(counting("tbl_videos", "id"))?></h2>
                        </div>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                          <span class="fa-stack fa-3x fa-lg fa-pull-right ">
                            <i class="fa fa-circle fa-stack-2x"></i>
                             <i class="fa fa-video fa-stack-1x fa-inverse"></i>
                        </span>
                      </div>
                    </div>
                  </div>
                </div>
                </div>
                </div>
                
                <div class="col-12 col-md-6 col-lg-4">
                <div class="card card-primary">
                     <div class="card-header">
                    <h4>Comments</h4>
                    <div class="card-header-action">
                      <a href="manage-comments" class="btn btn-primary">
                        View All
                      </a>
                    </div>
                  </div>
              <div class="card-statistic-4">
                  <div class="align-items-center justify-content-between">
                    <div class="row ">
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                        <div class="card-content">
                          <h2 class="mb-3  text-warning font-50"><?=thousandsNumberFormat(counting("tbl_comments", "cmt_id"))?></h2>
                        </div>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                          <span class="fa-stack fa-3x fa-lg fa-pull-right ">
                            <i class="fa fa-circle fa-stack-2x"></i>
                             <i class="fa fa-comments fa-stack-1x fa-inverse"></i>
                        </span>
                      </div>
                    </div>
                  </div>
                </div>
                </div>
                </div>
                
                <div class="col-12 col-md-6 col-lg-4">
                <div class="card card-primary">
                     <div class="card-header">
                    <h4>Reports</h4>
                    <div class="card-header-action">
                      <a href="manage-reports" class="btn btn-primary">
                        View All
                      </a>
                    </div>
                  </div>
              <div class="card-statistic-4">
                  <div class="align-items-center justify-content-between">
                    <div class="row ">
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pr-0 pt-3">
                        <div class="card-content">
                          <h2 class="mb-3  text-warning font-50"><?=thousandsNumberFormat(counting("tbl_reports", "id"))?></h2>
                        </div>
                      </div>
                      <div class="col-lg-6 col-md-6 col-sm-6 col-xs-6 pl-0">
                          <span class="fa-stack fa-3x fa-lg fa-pull-right ">
                            <i class="fa fa-circle fa-stack-2x"></i>
                             <i class="fa fa-flag fa-stack-1x fa-inverse"></i>
                        </span>
                      </div>
                    </div>
                  </div>
                </div>
                </div>
                </div>
                
                
                <div class="col-12 col-sm-12 col-lg-12">
                <div class="card">
                  <div class="card-header" style="display: inline-block;">
                    <h4>Users Analysis</h4>
                    <p style="margin-bottom: 0px;">New registrations</p>
                  </div>
                  
                  <div class="card-body">
       <div class="col-lg-2">
        <form method="get" id="graphFilter">
          <select class="form-control" name="filterByYear" style="box-shadow: none;height: auto;border-radius: 0px;font-size: 16px;">
            <?php 
              $currentYear=date('Y');
              $minYear=2020;

              for ($i=$currentYear; $i >= $minYear ; $i--) { 
                ?>
                <option value="<?=$i?>" <?=(isset($_GET['filterByYear']) && $_GET['filterByYear']==$i) ? 'selected' : ''?>><?=$i?></option>
                <?php
              }
            ?>
          </select>
        </form>
      </div>
      <div class="col-lg-12">
        <?php 
          if($no_data_status){
            ?>
            <h3 class="text-muted text-center" style="padding-bottom: 2em">No data found !</h3>
            <?php
          }
          else{
            ?>
            <div id="registerChart" style="width:100%">
              <p style="text-align: center;"><i class="fa fa-spinner fa-spin" style="font-size:3em;color:#aaa;margin-bottom:50px" aria-hidden="true"></i></p>
            </div>
            <?php    
          }
        ?>
      </div>
                  </div>
                </div>
              </div>
                
             
             <div class="col-md-6 col-lg-12 col-xl-6">
              <div class="card">
                <div class="card-header">
                  <h4>Latest Users</h4>
                </div>
                <div class="card-body">
                  <div class="table-responsive">
                      
                      <table class="table table-striped table-hover mb-0">
				<thead>
				<tr>
            <th>#</th>
			<th>Type</th>
			<th>Name</th>
			<th>Registered</th>
				</tr>
				</thead>

					<?php	
					$qry="select * FROM tbl_users WHERE role = 'User' ORDER BY user_id DESC LIMIT 10";
					$result=mysqli_query($mysqli,$qry);
        						$i=0;
        						while($row=mysqli_fetch_array($result))
        			{					
        			?>
		<tr>
		<td><?php echo $row['user_id']?></td>
		<td><?php echo $row['user_type']?></td>
		<td><?php echo $row['name']?></td>
		<td><?= time_ago_full(date('d-m-Y H:i:s', $row['registered_on']));?></td>

        </tr>
					 <?php $i++; }?> 
					</table>
                  </div>
                </div>
              </div>
            </div>
            
            <div class="col-md-6 col-lg-12 col-xl-6">
              <div class="card">
                <div class="card-header">
                  <h4>Latest Comments</h4>
                </div>
                <div class="card-body">
                  <div class="table-responsive">
                      
                      <table class="table table-striped table-hover mb-0">
				<thead>
				<tr>
            <th>#</th>
			<th>Name</th>
			<th>Comment</th>
			<th>Time</th>
				</tr>
				</thead>

					<?php	
					$qry="SELECT * FROM tbl_comments c
					LEFT JOIN tbl_users u ON u.user_id = c.uid
					ORDER BY c.cmt_id DESC LIMIT 10";
					$result=mysqli_query($mysqli,$qry);
        						$i=0;
        						while($row=mysqli_fetch_array($result))
        			{					
        			?>
		<tr>
		<td><?php echo $row['cmt_id']?></td>
		<td><?php echo $row['name']?></td>
		<td><?php echo $row['comment']?></td>
		<td><?= time_ago_full(date('d-m-Y H:i:s', $row['created']));?></td>

        </tr>
					 <?php $i++; }?> 
					</table>
                  </div>
                </div>
              </div>
            </div>
            
            <div class="col-md-6 col-lg-12 col-xl-6">
                <div class="card">
                  <div class="card-header">
                    <h4>Most Viewed News</h4>
                  </div>
                  <div class="card-body">
                    <ul class="list-unstyled list-unstyled-border">
                        <?php	
					$qry="select * FROM tbl_news ORDER BY views DESC LIMIT 10";
					$result=mysqli_query($mysqli,$qry);
        						$i=0;
        						while($row=mysqli_fetch_array($result))
        			{					
        			?>
                      <li class="media">
                        <img alt="image" src="images/<?= $row['thumbnail']?>" class="mr-3 most-view-list-img" >
                        <div class="media-body">
                          <div class="mt-0 mb-1 font-weight-bold"><?php echo stripslashes($row['news_title'])?></div>
                          <span class="label label-default" style="font-size: 10px;padding: 2px 8px;">Views : <?=thousandsNumberFormat($row['views'])?></span>
                        </div>
                      </li>
                       <?php $i++; }?> 
                    </ul>
                  </div>
                </div>
              </div>
              
            <div class="col-md-6 col-lg-12 col-xl-6">
                <div class="card">
                  <div class="card-header">
                    <h4>Most Viewed Videos</h4>
                  </div>
                  <div class="card-body">
                    <ul class="list-unstyled list-unstyled-border">
                        <?php	
					$qry="select * FROM tbl_videos ORDER BY views DESC LIMIT 10";
					$result=mysqli_query($mysqli,$qry);
        						$i=0;
        						while($row=mysqli_fetch_array($result))
        			{					
        			?>
                      <li class="media">
                        <img alt="image" src="images/<?= $row['thumbnail']?>" class="mr-3 most-view-list-img" >
                        <div class="media-body">
                          <div class="mt-0 mb-1 font-weight-bold"><?php echo stripslashes($row['video_title'])?></div>
                          <span class="label label-default" style="font-size: 10px;padding: 2px 8px;">Views : <?=thousandsNumberFormat($row['views'])?></span>
                        </div>
                      </li>
                       <?php $i++; }?> 
                    </ul>
                  </div>
                </div>
              </div>
            
            
          
        </div>
        </div>
        </div>
        </section>
        </div>

<?php include "includes/footer.php";?>        
        <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
<?php 
    if(!$no_data_status){
?>
<script type="text/javascript">
    google.charts.load('current', {packages: ['corechart', 'line']});
    google.charts.setOnLoadCallback(drawChart);

    function drawChart() {

      var data = new google.visualization.DataTable();
      data.addColumn('string', 'Month');
      data.addColumn('number', ' Total Users');

      data.addRows([<?=$countStr?>]);

      var options = {
        curveType: 'function',
        fontSize: 15,
        hAxis: {
          title: "Months of <?=(isset($_GET['filterByYear'])) ? $_GET['filterByYear'] : date('Y')?>",
          titleTextStyle: {
            color: '#000',
            bold:'true',
            italic: false
          },
        },
        vAxis: {
          title: "Nos of Users",
          titleTextStyle: {
            color: '#000',
            bold:'true',
            italic: false,
          },
          gridlines: { count: -1},
          format: '#',
          viewWindowMode: "explicit", viewWindow: {min: 0, max: 'auto'},
        },
        height: 400,
        chartArea:{
          left:100,top:20,width:'100%',height:'auto'
        },
        legend: {
            position: 'bottom'
        },
        lineWidth:4,
        animation: {
          startup: true,
          duration: 1200,
          easing: 'out',
        },
        pointSize: 5,
        pointShape: "circle",

      };
      var chart = new google.visualization.LineChart(document.getElementById('registerChart'));

      chart.draw(data, options);
    }

    $(document).ready(function () {
        $(window).resize(function(){
            drawChart();
        });
    });
</script>

<?php } ?>

<script type="text/javascript">
  
  // filter of graph
  $("select[name='filterByYear']").on("change",function(e){
    $("#graphFilter").submit();
  });

</script>
			